/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Analog;
import DE.siemens.ad.logo.model.AnalogOrBlockReference;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.IntegerOrBlockReference;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.util.AnalogValueProperties;
import DE.siemens.ad.logo.util.Util;
import java.io.IOException;

public class AnalogMathsParameter
extends Analog {
    static final long serialVersionUID = 0L;
    static final int OPERATOR_ADD = 0;
    static final int OPERATOR_SUB = 1;
    static final int OPERATOR_MUL = 2;
    static final int OPERATOR_DIV = 3;
    static final int PRI_LOW = 0;
    static final int PRI_MEDIUM = 1;
    static final int PRI_HIGH = 2;
    private int blockParameterSerializedDataVersion = 1;
    private static final int MIN_VALUE = Short.MIN_VALUE;
    private static final int MAX_VALUE = Short.MAX_VALUE;
    private AnalogOrBlockReference fP1;
    private AnalogOrBlockReference fP2;
    private AnalogOrBlockReference fP3;
    private AnalogOrBlockReference fP4;
    private final int opNum = 3;
    private int enOutputOptionID = 0;
    private int[] operator = new int[3];
    private int[] opPRI = new int[]{2, 1, 0};
    private transient boolean fZeroDivision;
    private transient boolean fOverflow;

    public AnalogMathsParameter() {
    }

    public AnalogMathsParameter(Block block) {
        super(block);
    }

    public int calculateAnalogValue(boolean en) {
        this.setZeroDivision(false);
        this.setOverflow(false);
        if (en) {
            this.fAmplifiedX = this.getArithmeticResult(this.getP1Properties().getValue(Short.MIN_VALUE, Short.MAX_VALUE), this.getP2Properties().getValue(Short.MIN_VALUE, Short.MAX_VALUE), this.getP3Properties().getValue(Short.MIN_VALUE, Short.MAX_VALUE), this.getP4Properties().getValue(Short.MIN_VALUE, Short.MAX_VALUE));
        } else {
            switch (this.getEnOutputOptionID()) {
                case 0: {
                    this.fAmplifiedX = 0;
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        return this.fAmplifiedX;
    }

    public int getArithmeticResult(int v1, int v2, int v3, int v4) {
        this.setZeroDivision(false);
        float result = 0.0f;
        switch (AnalogMathsParameter.getOpOrder(this.opPRI)) {
            case 6: {
                result = this.calculate(v1, this.calculate(v2, this.calculate(v3, v4, this.operator[2]), this.operator[1]), this.operator[0]);
                break;
            }
            case 9: {
                result = this.calculate(v1, this.calculate(this.calculate(v2, v3, this.operator[1]), v4, this.operator[2]), this.operator[0]);
                break;
            }
            case 18: 
            case 33: {
                result = this.calculate(this.calculate(v1, v2, this.operator[0]), this.calculate(v3, v4, this.operator[2]), this.operator[1]);
                break;
            }
            case 24: {
                result = this.calculate(this.calculate(v1, this.calculate(v2, v3, this.operator[1]), this.operator[0]), v4, this.operator[2]);
                break;
            }
            case 36: {
                result = this.calculate(this.calculate(this.calculate(v1, v2, this.operator[0]), v3, this.operator[1]), v4, this.operator[2]);
                break;
            }
        }
        if (this.isZeroDivision()) {
            return Short.MAX_VALUE;
        }
        this.setOverflow(result > 32767.0f || result < -32768.0f);
        if (result > 32767.0f) {
            return Short.MAX_VALUE;
        }
        if (result < -32768.0f) {
            return Short.MIN_VALUE;
        }
        return (int)(result > 0.0f ? (double)result + 0.5 : (double)result - 0.5);
    }

    private float calculate(float operand1, float operand2, int op) {
        switch (op) {
            case 0: {
                return operand1 + operand2;
            }
            case 1: {
                return operand1 - operand2;
            }
            case 2: {
                return operand1 * operand2;
            }
            case 3: {
                if (operand2 == 0.0f) {
                    this.setZeroDivision(true);
                    break;
                }
                return operand1 / operand2;
            }
        }
        return 0.0f;
    }

    private static int getOpOrder(int[] opPRIs) {
        int opOrder = 0;
        for (int i = 0; i < opPRIs.length; ++i) {
            opOrder <<= 2;
            opOrder += opPRIs[i];
        }
        return opOrder;
    }

    public StringBuffer getFormulaText(int[] ops, int[] opPRIs) {
        StringBuffer formula = new StringBuffer();
        String sV1 = this.getP1Properties().getParameterText();
        String sV2 = this.getP2Properties().getParameterText();
        String sV3 = this.getP3Properties().getParameterText();
        String sV4 = this.getP4Properties().getParameterText();
        switch (AnalogMathsParameter.getOpOrder(opPRIs)) {
            case 6: {
                formula.append(sV1).append(AnalogMathsParameter.getOpString(ops[0])).append("(" + sV2).append(AnalogMathsParameter.getOpString(ops[1])).append("(" + sV3).append(AnalogMathsParameter.getOpString(ops[2])).append(sV4 + "))");
                break;
            }
            case 9: {
                formula.append(sV1).append(AnalogMathsParameter.getOpString(ops[0])).append("((" + sV2).append(AnalogMathsParameter.getOpString(ops[1])).append(sV3 + ")").append(AnalogMathsParameter.getOpString(ops[2])).append(sV4 + ")");
                break;
            }
            case 18: 
            case 33: {
                formula.append("(" + sV1).append(AnalogMathsParameter.getOpString(ops[0])).append(sV2 + ")").append(AnalogMathsParameter.getOpString(ops[1])).append("(" + sV3).append(AnalogMathsParameter.getOpString(ops[2])).append(sV4 + ")");
                break;
            }
            case 24: {
                formula.append("(" + sV1).append(AnalogMathsParameter.getOpString(ops[0])).append("(" + sV2).append(AnalogMathsParameter.getOpString(ops[1])).append(sV3 + "))").append(AnalogMathsParameter.getOpString(ops[2])).append(sV4);
                break;
            }
            case 36: {
                formula.append("((" + sV1).append(AnalogMathsParameter.getOpString(ops[0])).append(sV2 + ")").append(AnalogMathsParameter.getOpString(ops[1])).append(sV3 + ")").append(AnalogMathsParameter.getOpString(ops[2])).append(sV4);
                break;
            }
            default: {
                formula.append("Error");
            }
        }
        return formula;
    }

    private static char getOpString(int op) {
        char ret;
        switch (op) {
            case 0: {
                ret = '+';
                break;
            }
            case 1: {
                ret = '-';
                break;
            }
            case 2: {
                ret = '*';
                break;
            }
            case 3: {
                ret = '/';
                break;
            }
            default: {
                ret = '?';
            }
        }
        return ret;
    }

    public String getParameterText() {
        StringBuffer buffer = new StringBuffer(super.getParameterText());
        if (buffer.length() > 0) {
            buffer.append("\n");
        }
        buffer.append("V1=").append(this.getP1Properties().getParameterText()).append(this.getProtectionSign()).append("\nV2=").append(this.getP2Properties().getParameterText()).append("\nV3=").append(this.getP3Properties().getParameterText()).append("\nV4=").append(this.getP4Properties().getParameterText()).append("\nPoint=").append(this.getDecimalPlace());
        buffer.append("\n").append(this.getFormulaText(this.operator, this.opPRI));
        return buffer.toString();
    }

    public String calculateCurrentParameterText() {
        String value = Double.toString(this.fAmplifiedX);
        value = Util.addTrailingSpaces(value, 8);
        this.fireParameterUpdateEvent();
        return value;
    }

    public AnalogOrBlockReference getP1Properties() {
        if (this.fP1 == null) {
            this.fP1 = new AnalogOrBlockReference(this);
            AnalogValueProperties analogValueProperties = new AnalogValueProperties(Short.MIN_VALUE, Short.MAX_VALUE, 1, 0, 0, "error.analogMaths.p1", "Error input P1");
            analogValueProperties.setSuppressLeadingZeroes(true);
            this.fP1.setAnalogValueProperties(analogValueProperties);
        }
        this.fP1.setDecimalPlace(this.getDecimalPlace());
        return this.fP1;
    }

    public AnalogOrBlockReference getP2Properties() {
        if (this.fP2 == null) {
            this.fP2 = new AnalogOrBlockReference(this);
            AnalogValueProperties analogValueProperties = new AnalogValueProperties(Short.MIN_VALUE, Short.MAX_VALUE, 1, 0, 0, "error.analogMaths.p2", "Error input P2");
            analogValueProperties.setSuppressLeadingZeroes(true);
            this.fP2.setAnalogValueProperties(analogValueProperties);
        }
        this.fP2.setDecimalPlace(this.getDecimalPlace());
        return this.fP2;
    }

    public AnalogOrBlockReference getP3Properties() {
        if (this.fP3 == null) {
            this.fP3 = new AnalogOrBlockReference(this);
            AnalogValueProperties analogValueProperties = new AnalogValueProperties(Short.MIN_VALUE, Short.MAX_VALUE, 1, 0, 0, "error.analogMaths.p3", "Error input P3");
            analogValueProperties.setSuppressLeadingZeroes(true);
            this.fP3.setAnalogValueProperties(analogValueProperties);
        }
        this.fP3.setDecimalPlace(this.getDecimalPlace());
        return this.fP3;
    }

    public AnalogOrBlockReference getP4Properties() {
        if (this.fP4 == null) {
            this.fP4 = new AnalogOrBlockReference(this);
            AnalogValueProperties analogValueProperties = new AnalogValueProperties(Short.MIN_VALUE, Short.MAX_VALUE, 1, 0, 0, "error.analogMaths.p4", "Error input P4");
            analogValueProperties.setSuppressLeadingZeroes(true);
            this.fP4.setAnalogValueProperties(analogValueProperties);
        }
        this.fP4.setDecimalPlace(this.getDecimalPlace());
        return this.fP4;
    }

    public void setOperator(int index, int op) {
        this.operator[index] = op;
    }

    public int getOperator(int index) {
        return this.operator[index];
    }

    public int getOperator1() {
        return this.operator[0];
    }

    public void setOperator1(int op) {
        this.operator[0] = op;
    }

    public int getOperator2() {
        return this.operator[1];
    }

    public void setOperator2(int op) {
        this.operator[1] = op;
    }

    public int getOperator3() {
        return this.operator[2];
    }

    public void setOperator3(int op) {
        this.operator[2] = op;
    }

    public void setOpPRI(int index, int pri) {
        this.opPRI[index] = pri;
    }

    public int getOpPRI(int index) {
        return this.opPRI[index];
    }

    public int getOpPRI1() {
        return this.opPRI[0];
    }

    public void setOpPRI1(int pri) {
        this.opPRI[0] = pri;
    }

    public int getOpPRI2() {
        return this.opPRI[1];
    }

    public void setOpPRI2(int pri) {
        this.opPRI[1] = pri;
    }

    public int getOpPRI3() {
        return this.opPRI[2];
    }

    public void setOpPRI3(int pri) {
        this.opPRI[2] = pri;
    }

    public void setP1Properties(AnalogOrBlockReference value) {
        this.fP1.setValue(value);
    }

    public void setP2Properties(AnalogOrBlockReference value) {
        this.fP2.setValue(value);
    }

    public void setP3Properties(AnalogOrBlockReference value) {
        this.fP3.setValue(value);
    }

    public void setP4Properties(AnalogOrBlockReference value) {
        this.fP4.setValue(value);
    }

    public void setP1Properties(IntegerOrBlockReference value) {
        this.fP1.setValue(value);
    }

    public void setP2Properties(IntegerOrBlockReference value) {
        this.fP2.setValue(value);
    }

    public void setP3Properties(IntegerOrBlockReference value) {
        this.fP3.setValue(value);
    }

    public void setP4Properties(IntegerOrBlockReference value) {
        this.fP4.setValue(value);
    }

    public int getAmplifiedAq() {
        return this.fAmplifiedX;
    }

    public void setAmplifiedAq(int analogValue) {
        this.fAmplifiedX = analogValue;
    }

    public AnalogValueProperties getAmplifiedXProperties() {
        if (this.fAmplifiedXProperties == null) {
            this.fAmplifiedXProperties = new AnalogValueProperties(MIN_TRIGGER, MAX_TRIGGER, 1, (int)this.fXInput, this.getDecimalPlace(), this.isAnalogValueDecimalPlacesAvailable(), "error.dialog.invalidValue", "Invalid Value");
        }
        this.fAmplifiedXProperties.setCurrentValue(this.fAmplifiedX);
        this.fAmplifiedXProperties.setDecimalPlace(this.getDecimalPlace());
        return this.fAmplifiedXProperties;
    }

    public AnalogValueProperties getArithmeticResultProperties() {
        return new AnalogValueProperties(MIN_TRIGGER, MAX_TRIGGER, 1, this.fAmplifiedX, this.getDecimalPlace(), this.isAnalogValueDecimalPlacesAvailable(), "error.dialog.invalidValue", "Invalid Value");
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.fP1);
        dw.writeStorable(this.fP2);
        dw.writeStorable(this.fP3);
        dw.writeStorable(this.fP4);
        for (int i = 0; i < 3; ++i) {
            dw.writeInt(this.operator[i]);
            dw.writeInt(this.opPRI[i]);
        }
        dw.writeInt(this.enOutputOptionID);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fP1 = (AnalogOrBlockReference)dr.readStorable();
        this.fP2 = (AnalogOrBlockReference)dr.readStorable();
        this.fP3 = (AnalogOrBlockReference)dr.readStorable();
        this.fP4 = (AnalogOrBlockReference)dr.readStorable();
        for (int i = 0; i < 3; ++i) {
            this.operator[i] = dr.readInt();
            this.opPRI[i] = dr.readInt();
        }
        this.enOutputOptionID = dr.readInt();
    }

    public int getEnOutputOptionID() {
        return this.enOutputOptionID;
    }

    public void setEnOutputOptionID(int enOutputOptionID) {
        this.enOutputOptionID = enOutputOptionID;
    }

    public int getOpNum() {
        return 3;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        this.fAmplifiedX = 0;
    }

    public boolean isZeroDivision() {
        return this.fZeroDivision;
    }

    private void setZeroDivision(boolean zeroDivision) {
        this.fZeroDivision = zeroDivision;
    }

    public boolean isOverflow() {
        return this.fOverflow;
    }

    private void setOverflow(boolean overflow) {
        this.fOverflow = overflow;
    }
}

